<?php

/**
 * I am THE file that defines the {{generator_name}} public specific functionalities
 * I extend Glb_Plugin_Bud, and take profit of all it's functionalities
 *
 * This file is distributed under the same license as the {{generator_package}} package.
 *
 * @since             {{generator_version}}
 * @link              {{generator_link}}
 * @author            {{generator_author}}
 * @package           {{generator_package}}
 */

class Glb_{{generator_sname_wc_u}}_Public extends Glb_Plugin_Bud {

    public function __construct($plugin) {

        parent::__construct($plugin);

        // add a route. If you add the following route,
        // then the URL http://mysite/glb-{{generator_sname_lc_d}}-connector
        // will fall in the following callback
        $this->plugin->add_route('glb-{{generator_sname_lc_d}}-connector', [$this, 'process_connector']);

        // add a shortcode (can be usefull)
        $this->plugin->add_shortcode( 'glb_{{generator_sname_lc_u}}', [$this, 'glb_{{generator_sname_lc_u}}_shortcode'] );

        <<GENERATOR_ROLES
        // WP admin access control for access_users vs admin_users
        if (Glb_Users::current_has_caps('glb_{{generator_sname_lc_u}}_access') &&
            !Glb_Users::current_has_caps(['glb_{{generator_sname_lc_u}}_admin', 'administrator', 'manage_options'])) {
            $this->plugin->add_action( 'admin_init',     [$this, 'access_dashboard_redirect'] );
            $this->plugin->add_action( 'admin_bar_menu', [$this, 'access_hide_toolbar_items'], 999 );
        }
        GENERATOR_ROLES>>

    }

    /**
     * Redirect glb_{{generator_sname_lc_u}}_users to the home page if trying to load admin page wich is not "profile"
     */
    public function access_dashboard_redirect() {
        global $pagenow;
        if ( 'profile.php' != $pagenow ) {
            wp_redirect( home_url() );
            exit;
        }
    }

    /**
     * Hide toolbar items if capability 'glb_{{generator_sname_lc_u}}_admin' is not allowed
     * @param $wp_admin_bar
     */
    public function access_hide_toolbar_items($wp_admin_bar) {
        $allowed = [
            'top-secondary' => ['my-account'],
            'my-account' => ['user-actions'],
            'user-actions' => [ 'user-info', 'edit-profile', 'logout', 'switch-back'],
            'menu-toggle' => true,
            'languages' => true,
            'site-name' => [],
        ];

        if ( !is_object($wp_admin_bar) ) {
            return;
        }


        // Clean the AdminBar
        $nodes = $wp_admin_bar->get_nodes();
        foreach( $nodes as $node )
        {
            if (!$node->parent && array_key_exists($node->id, $allowed)) {
                continue;
            }
            if ( $node->parent && array_key_exists($node->parent, $allowed) &&
                ($allowed[$node->parent] === true || in_array($node->id, $allowed[$node->parent])) ) {
                continue;
            }
            $wp_admin_bar->remove_menu( $node->id );
        }
    }

    public function glb_{{generator_sname_lc_u}}_shortcode($param, $content) {

        // if not logged in, then show the login form
        if (!Glb_Users::current_has_caps('glb_{{generator_sname_lc_u}}_access')) {
            return $this->plugin->render_template('core:elements/glb-core-login-form', ['message' => __glb('Hmmm... It\'s time to log in !')], true);
        }
        // otherwise, display shortcode
        return $this->plugin->render_template('elements/glb-{{generator_sname_lc_u}}-shortcode', [], true);
    }


    /**
     * This connector function allows you to do a lot of things
     * @param $params
     */
    public function process_connector($params) {
        Glb_Log::notice('{{generator_sname_lc_u}} process_connector ');
        echo "<div>Hello guys, I am the connector !</div>";
    }
}